#! /usr/bin/perl


    #   NOTE: This program was automatically generated by the Nuweb
    #   literate programming tool.  It is not intended to be modified
    #   directly.  If you wish to modify the code or use it in another
    #   project, you should start with the master, which is kept in the
    #   file blockchain_tools.w in the public GitHub repository:
    #       https://github.com/Fourmilab/blockchain_tools.git
    #   and is documented in the file blockchain_tools.pdf in the root directory
    #   of that repository.

    #
    #   Build 818  2021-10-24 21:02


    
        require 5;
        use strict;
        use warnings;
        use utf8;

        use constant FALSE => 0;
        use constant TRUE => 1;
    

    use LWP;
    use JSON;
    use Text::CSV qw(csv);
    use Getopt::Long qw(GetOptionsFromArray);
    use POSIX qw(strftime);
    use Term::ReadKey;
    use Statistics::Descriptive;

    use Data::Dumper;

    my $block_start = -1;           # Starting block
    my $block_end = -1;               # End block
    my $block_file = "";           # Incremental scanning block file
    my @watch_addrs;                               # Addresses to watch
    my $watch_file = "";           # File containing watch addresses
    my $log_file = "";               # Log file
    my $verbose = 0;              # Verbose output ?
    my $poll_time = 300;   # Poll interval in seconds
    my $last_block_time = -1;                       # Time of last block
    my $b_interval_smoothed = -1;                   # Smoothed inter-block interval, seconds
    my $b_interval_smoothing = 0.2;                 # Interval smoothing factor
    my $stats = FALSE;                              # Show statistics of blocks ?
    my $statlog = "";                               # Block statistics log file
    my $wallet = FALSE;             # Monitor unspent funds in wallet ?
    
        my $RPCmethod = "rpc"; # RPC query method: "local", "ssh", "rpc"
        my $RPChost = "localhost";           # Host where bitcoind runs
        my $RPCport = 8332;             # bitcoind RPC query port (standard 8332)
        my $RPCcli = "bitcoin-cli";    # Path to run bitcoin-cli
        my $RPCuser = "myuser";           # RPC user name
        my $RPCpass = "";       # RPC password
    

    my %options = (
        
            "clipath=s"     => \$RPCcli,
            "host=s"        => \$RPChost,
            "method=s"      => \$RPCmethod,
            "rpcpass=s"     => \$RPCpass,
            "port=i"        => \$RPCport,
            "user=s"        => \$RPCuser,
        
        "bfile=s"       => \$block_file,
        "end=i"         => \$block_end,
        "help"          => \&showHelp,
        "lfile=s"       => \$log_file,
        "poll=i"        => \$poll_time,
        "sfile=s"       => \$statlog,
        "start=i"       => \$block_start,
        "stats"         => \$stats,
        "type=s"        =>  sub { print("$_[1]\n"); },
        "verbose+"      => \$verbose,
        "wallet"        => \$wallet,
        "watch=s"       => \@watch_addrs,
        "wfile=s"       => \$watch_file
    );

    processConfiguration();

    GetOptions(
        %options
    ) || die("Command line option error");

    my $statc = $stats || ($statlog ne "");

    my %adrh;

    #   Add watch addresses specified on the command line
    foreach my $a (@watch_addrs) {
        my ($label, $balance) = ("", "");

        if ($a =~ s/^(\w+),//) {
            $label = $1;
        }
        if ($a =~ s/,[\d\.]+$//) {
            $balance = $1;
        }
        $adrh{$a} = [ $label, $balance ];
    }
    undef(@watch_addrs);

    #   Add watch addresses specified in a -wfile
    if ($watch_file ne "") {
        my $csv = Text::CSV->new({ binary => 1 }) ||
            die("Cannot use CSV: " . Text::CSV->error_diag());
        open(WF, "<$watch_file") || die("Cannot open $watch_file");
        while (my $l = <WF>) {
            chomp($l);
            $l =~ s/^\s+//;
            $l =~ s/\s+$//;
            if (($l ne "") && ($l !~ m/^#/)) {
                if ($csv->parse($l)) {
                    my @fields = $csv->fields;
                    if ($fields[1] !~ m/^0x/i) {
                        $adrh{$fields[1]} = [ $fields[0], $fields[3] ];
                    }
                }
            }
        }
        close(WF);
    }

    if (scalar(keys(%adrh)) == 0) {
        print(STDERR "No watch addresses specified.\n");
        exit(2);
    }

    if (($RPCmethod eq "rpc") &&
        ((!defined($RPCpass)) || ($RPCpass eq ""))) {
        $RPCpass = getPassword("Bitcoin RPC password: ");
    }

    #   If a block file is present, read start block from it
    if ($block_file ne "") {
        open(BF, "<$block_file") || die("Cannot open block file $block_file");
        my $l = <BF>;
        close(BF);
        chomp($l);
        if ($l =~ m/(\d+)/) {
            $block_start = $1 + 1;
        } else {
            print(STDERR "Invalid value in block file.\n");
            exit(2);
        }
    }

    #   If no end block specified, use most recent block

    if ($block_end < 0) {
        $block_end = sendRPCcommand([ "getblockcount" ]);
    }

    #   If negative start block specified, start that number
    #   before the last block.

    if ($block_start < 0) {
        $block_start = $block_end + $block_start
    }

    if (($block_start > $block_end) && ($poll_time == 0)) {
        print("No blocks to scan.\n");
        exit(0);
    }

    updateWalletAddresses();

    do {
        my $myaddrs = [];

        if ($block_start <= $block_end) {
            print("Scanning blocks $block_start to $block_end.\n") if $verbose;
        }

        my $scanned = 0;
        for (my $j = $block_start; $j <= $block_end; $j++) {
            if ($wallet && ($j == $block_start)) {
                updateWalletAddresses();
            }
            print("  Scanning block $j.\n") if $verbose;
            my $mine = scanBlock($j, $verbose);
            if (scalar(@$mine) > 0) {
                push(@$myaddrs, $mine);
            }
            $scanned++;
        }

        my $nref = (scalar(@$myaddrs) == 0) ? 0 : scalar(@{$myaddrs->[0]});
        if (scalar($nref) > 0) {
            printf("%d reference%s to watched addresses:\n",
                $nref, ($nref > 1) ? "s" : "");
            for (my $i = 0; $i < $nref; $i++) {
                my ($b_height, $b_hash, $b_time, $t_txid, $a_addr, $t_value) =
                   ($myaddrs->[0]->[$i]->[0], $myaddrs->[0]->[$i]->[1],
                    $myaddrs->[0]->[$i]->[2], $myaddrs->[0]->[$i]->[3],
                    $myaddrs->[0]->[$i]->[4], $myaddrs->[0]->[$i]->[5]);
                my $utime = etime($b_time);

                my $logItem = sprintf("%-12s  %36s  %11.8f  %19s  %8d  %64s  %64s\n",
                    $adrh{$a_addr}->[0], $a_addr, $t_value, $utime, $b_height, $t_txid, $b_hash);
                print($logItem);
                if ($log_file ne "") {
                    open(LF, ">>$log_file")|| die("Cannot open log file $log_file");
                    printf(LF "\"%s\",%s,%.8f,%s,%d,%s,%s\n",
                        $adrh{$a_addr}->[0], $a_addr, $t_value, $utime,
                        $b_height, $t_txid, $b_hash);
                    close(LF);
                }
           }
        }

        if (($block_file ne "") && ($scanned > 0)) {
            open(BF, ">$block_file") || die("Cannot open block file for update");
            print(BF "$block_end\n");
            close(BF);
            print("Updated block file to last block $block_end.\n") if $verbose;
        }

        if ($poll_time > 0) {
            $block_start = $block_end + 1;
            sleep($poll_time);
            print("Resuming scan after $poll_time seconds at " .
                etime(time()) . ".\n") if $verbose;
            $block_end = sendRPCcommand([ "getblockcount" ]);
        }
    } while ($poll_time > 0);

    #   Local functions
    
        sub scanBlock {
            my ($height, $verbose) = @_;

            my @hits;
    
            my $bh = sendRPCcommand([ "getblockhash", "$height" ]);
            print("    Block hash $bh\n") if $verbose;
            my $blk = sendRPCcommand([ "getblock",  $bh, "2" ]);
            my $r = decode_json($blk);
    
            my $b_height = $r->{height};        # Block height (index)
            my $b_hash = $r->{hash};            # Block hash
            my $b_time = $r->{time};            # Block time
            my $b_nTx = $r->{nTx};              # Transactions in block

            print("    Block $b_height " . gmtime($b_time) .
                  " Transactions $b_nTx\n") if $verbose >= 1;

            my ($stat_value, $stat_size);
            my $stat_reward = 0;
            if ($statc) {
                $stat_value = Statistics::Descriptive::Sparse->new();
                $stat_size = Statistics::Descriptive::Sparse->new();
            }
    
            my %vincache;

            for (my $t = 0; $t < $b_nTx; $t++) {
                #   Transaction ID
                my $t_txid = $r->{tx}->[$t]->{txid};
                if ($statc) {
                    $stat_size->add_data($r->{tx}->[$t]->{vsize});
                }
    
                my $t_nvin = scalar(@{$r->{tx}->[$t]->{vin}});
                my $t_nvout = scalar(@{$r->{tx}->[$t]->{vout}});

                print("  $t.  $t_txid  In: $t_nvin  Out: $t_nvout\n") if $verbose >= 2;

                for (my $v = 0; $v < $t_nvin; $v++) {
                    if (defined($r->{tx}->[$t]->{vin}->[$v]->{txid}) &&
                        defined($r->{tx}->[$t]->{vin}->[$v]->{vout})) {
                        my ($vintx, $vinn) = ($r->{tx}->[$t]->{vin}->[$v]->{txid},
                            $r->{tx}->[$t]->{vin}->[$v]->{vout});
                        my $vi;
                        if (!defined($vi = $vincache{$vintx})) {
                            my $vitx = sendRPCcommand([ "getrawtransaction",  $vintx, "true" ]);
                            $vi = decode_json($vitx);
                            $vincache{$vintx} = $vi;
                        }
                        if (defined($vi->{vout}->[$vinn]->{scriptPubKey}->{addresses})) {
                            #   This is not a "coinbase" transaction.  Scan source addresses
                            my $vi_naddr = scalar(@{$vi->{vout}->[$vinn]->{scriptPubKey}->{addresses}});
                            #   Loop over addresses in vout item
                            for (my $a = 0; $a < $vi_naddr; $a++) {
                                my $a_addr = $vi->{vout}->[$vinn]->{scriptPubKey}->{addresses}->[$a];
                                my $t_value = $vi->{vout}->[$vinn]->{value};
                                if (!defined($t_value)) {
                                    $t_value = 0;
                                }
                                my $flag = $adrh{$a_addr};
                                if ($verbose >= 3) {
                                    my $pflag = $flag ? " *****" : "";
                                    print("      In  $v.$a.  $a_addr$pflag\n");
                                }
                                if ($flag) {
                                    #   This is one of the addresses we're watching: add to the hit list
                                    push(@hits, [ $b_height, $b_hash, $b_time, $t_txid, $a_addr, -$t_value ]);
                                }
                            }
                        }
                    }
                }
    
                #   Loop over vout items
                for (my $v = 0; $v < $t_nvout; $v++) {
                    if (defined($r->{tx}->[$t]->{vout}->[$v]->{scriptPubKey}) &&
                        defined($r->{tx}->[$t]->{vout}->[$v]->{scriptPubKey}->{addresses})) {
                        my $v_naddr = scalar(@{$r->{tx}->[$t]->{vout}->[$v]->{scriptPubKey}->{addresses}});
                        #   Loop over addresses in vout item
                        for (my $a = 0; $a < $v_naddr; $a++) {
                            my $a_addr = $r->{tx}->[$t]->{vout}->[$v]->{scriptPubKey}->{addresses}->[$a];
                            my $t_value = $r->{tx}->[$t]->{vout}->[$v]->{value};
                            if (!defined($t_value)) {
                                $t_value = 0;
                            }
                            if ($t == 0) {
                                $stat_reward += $t_value;
                            }
                            my $flag = $adrh{$a_addr};
                            if ($verbose >= 3) {
                                my $pflag = $flag ? " *****" : "";
                                print("      Out $v.$a.  $a_addr$pflag\n");
                            }
                            if ($flag) {
                                #   This is one of the addresses we're watching: add to the hit list
                                push(@hits, [ $b_height, $b_hash, $b_time, $t_txid, $a_addr, $t_value ]);
                            }
                            if ($statc && ($t_value > 0)) {
                                $stat_value->add_data($t_value);
                            }
                        }
                    }
                }
            }
            if ($statc) {
                
                    if ($stats) {
                        print("  Block $b_height  " . etime($b_time) . " $b_nTx transactions\n");
                        my $brw = blockReward($b_height);
                        printf("    Reward %.2f (mining block %.2f, transaction fees %.2f)\n",
                               $stat_reward, $brw, $stat_reward - $brw);
                        printf("    Size: min %d  max %d  mean %.2f  SD %.2f  Total %d\n",
                            $stat_size->min(), $stat_size->max(), $stat_size->mean(),
                            $stat_size->standard_deviation(), $stat_size->sum());
                        printf("    Value: min %.8f  max %.8g  mean %.8g  SD %.8g  Total %.8g\n",
                            $stat_value->min(), $stat_value->max(), $stat_value->mean(),
                            $stat_value->standard_deviation(), $stat_value->sum());
                        if ($last_block_time > 0) {
                            my $b_interval = $b_time - $last_block_time;
                            if ($b_interval_smoothed >= 0) {
                                $b_interval_smoothed = $b_interval_smoothed +
                                    ($b_interval_smoothing *
                                        ($b_interval - $b_interval_smoothed));
                            } else {
                                $b_interval_smoothed = $b_interval;
                            }
                            printf("    Time since last block: %.2f minutes, smoothed %.2f.\n",
                                $b_interval / 60, $b_interval_smoothed / 60);
                        }

                    }
                    if ($statlog) {
                        open(SL, ">>$statlog");
                            printf(SL "%12d,%d,%d,%d,%d,%.2f,%.2f,%d,%.8f,%.8g,%.8g,%.8g,%.8g,%.8g,%.8g\n",
                                $b_height, $b_time, $b_nTx,
                                $stat_size->min(), $stat_size->max(), $stat_size->mean(),
                                $stat_size->standard_deviation(), $stat_size->sum(),
                                $stat_value->min(), $stat_value->max(), $stat_value->mean(),
                                $stat_value->standard_deviation(), $stat_value->sum(),
                                $stat_reward, blockReward($b_height));
                        close(SL);
                    }
                
            }
            $last_block_time = $b_time;
            return \@hits;
        }
    
    
        sub updateWalletAddresses {
            my $now = time();

            foreach my $adr (keys(%adrh)) {
                 if (($adrh{$adr}->[1] =~ m/^W/) &&
                     (($now - $adrh{$adr}->[2]) > 3600)) {
                     printf("Purged wallet address $adr, age %d seconds.\n",
                        $now - $adrh{$adr}->[2]); # if ($verbose >= 2);
                     delete($adrh{$adr});
                 }
            }
    
            #   Retrieve unspent addresses from wallet and add to watch hash
            my $uw = sendRPCcommand([ "listunspent" ]);
            if (defined($uw)) {
                my $w = decode_json($uw);
                for (my $i = 0; $i < scalar(@$w); $i++) {
                    my $addr = $w->[$i]->{address};
                    my $balance = $w->[$i]->{amount};
                    my $label = $w->[$i]->{label};
                    if (!defined($label)) {
                        $label = "Wallet" . ($i + 1);
                    }
                    print("Watching wallet $label,$addr,W$balance,$now\n") if ($verbose >= 2);
                    $adrh{$addr} = [ $label, "W$balance", $now ];
                }
            }
        }
    
    
        sub showHelp {
            my $help = <<"    EOD";
    perl address_watch.pl [ option... ] address_file
      Commands and arguments:
        -bfile filename     Set file to save last block scanned
        -end n              Last block to scan
        -help               Print this message
        -lfile filename     Set log file
        -poll n             Poll for new block every n seconds, 0 = never
        -sfile filename     Write block statistics to named file
        -start n            First block to scan
        -stats              Generate block statistics
        -type Any text      Display text argument on standard output
        -verbose            Print debug information, more for every -verbose
        -wallet             Scan wallet for addresses to watch
        -wfile filename     CSV file of addresses to watch
      
      Bitcoin API access configuration options:
        -clipath path       Path name to execute bitcoin-cli command line utility
        -host hostname      Host (name or IP address) where Bitcoin Core runs
        -method which       Query method: local, rpc, ssh
        -rpcpass "text"     Bitcoin RPC API password
        -port n             Port for RPC API requests (default 8332)
        -user userid        User name for requests via ssh
    EOD
            $help =~ s/^    //gm;
            print($help);
            exit(0);
        }
    

    #   Utility functions
    
        sub etime {
            my ($t) = @_;

            return strftime("%F %T", gmtime($t));
        }
    
    
        sub processCommand {
            my ($command, $interactive) = @_;

            my ($verb, $noun) = ("", "");
            $command =~ s/\s+$//;
            #   Ignore blank lines and comments
            if (($command ne "") && ($command !~ m/^\s*#/)) {
                $command =~ m/^\s*(\w+)(?:\s+(\S.*?))?\s*$/ ||
                    die("Unable to parse command \"$command\"\n");
                ($verb, $noun) = ($1, $2);
                my $inop = TRUE;
                foreach my $op (keys(%options)) {
                    $op =~ s/(?:\+|=\w+)$//;
                    if ($op eq $verb) {
                        $inop = FALSE;
                        last;
                    }
                }
                if ($inop) {
                    if ($interactive) {
                        return ("", "") if ($verb =~ m/^(?:en|ex|qu)/);
                        print("Unknown command/option \"$verb\".\n");
                        return ("?", "");
                    } else {
                        return ("", "");
                    }
                }
                $noun = "" if (!defined($noun));
                my @optarr = ( "-$verb" );
                if ($noun ne "") {
                    push(@optarr, $noun);
                }
                if (!GetOptionsFromArray(\@optarr, %options)) {
                    if ($interactive) {
                        print("Error in command \"$command\".\n");
                    }
                }
            }
            return ($verb, $noun);
        }
    
        my $interactive = FALSE;

        sub arg_inter {
            $interactive = TRUE;
            while (TRUE) {
                print("> ");
                my $l = <> || last;
                chomp($l);
                if ($l !~ m/^\s*$/) {
                    my ($v, $n) = (" ", "");
                    eval {
                        ($v, $n) = processCommand($l, TRUE);
                    };
                    last if ($v eq "");
                }
            }
            $interactive = FALSE;
        }
    
        sub processCommandFile {
            my ($fname) = @_;

            open(CI, "<$fname") ||
                die("Cannot open command file $fname");

            while (my $l = <CI>) {
                chomp($l);
                my ($v, $n) = processCommand($l, FALSE);
            }
            close(CI);
        }
    
        sub processConfiguration {
            if (-f "blockchain_tools.conf") {
                processCommandFile("blockchain_tools.conf");
            }
            my $progName = "perl/address_watch.pl";
            $progName =~ m|^(?:[^/]*/)?(\w+)\.\w+$| ||
                die("Cannot extract program name from $progName");
            $progName = $1;
            if (-f "$progName.conf") {
                processCommandFile("$progName.conf");
            }
        }
    
    
        sub sendRPCcommand {
            my ($args) = @_;

            my $result;

            if ($RPCmethod eq "local") {
                
                    map({ s/^(\[.*?\])$/'$1'/ } @$args);
                    my $cmd = join(" ", @$args);
                    $result = `$RPCcli $cmd 2>&1`;

                

            } elsif ($RPCmethod eq "ssh") {
                
                    map({ s/^(\[.*?\])$/'$1'/ } @$args);
                    my $cmd = join(" ", @$args);
                    $cmd =~ s/"/\\"/g;
                    $result = `ssh $RPChost $RPCcli \"$cmd\" 2>&1`;
                

             } elsif ($RPCmethod eq "rpc") {
                
                    my $method = shift(@$args);
                
                    for (my $i = 0; $i < scalar(@$args); $i++) {
                        if ($args->[$i] !~ m/^(?:true|false|null|[\d\.]+|".*"|\[.*?\])$/) {
                            my $s = $args->[$i];
                            $s =~ s/"/\\"/g;
                            $args->[$i] = "\"$s\"";
                        }
                    }
                
                    my $params = join(",\n        ", @$args);
                    my $request = LWP::UserAgent->new();
                    $request->agent("trans_watch");
                    #   Specify requester's credentials, including user and password
                    $request->credentials("$RPChost:$RPCport", "jsonrpc",
                        $RPCuser, $RPCpass);
                    #   Compose JSON query to be sent via POST
                    my $query = <<"                EOD";
                {
                "jsonrpc": "1.0",
                "id": "trans_watch",
                "method": "$method",
                "params": [
                $params
                ]
                }
                EOD
                
                    my $rq = HTTP::Request->new("POST",
                                                "http://$RPChost:$RPCport/",
                                                [ "Content-Type" => "text/plain" ],
                                                $query);
                    my $reply = $request->request($rq);
                
                    if ($reply->{_rc} == 200) {
                        $result = $reply->{_content};
                        $result =~ s/^\{"result":(.*?)(,"error":[^\{]+\})$/$1/ ||
                            die("Cannot extract RPC result");
                        my $errstat = $2;
                        if ($errstat !~ m/"error"\s*:\s*null/) {
                            $result = undef;
                        }
                    }
                

           } else {
                print(STDERR "Unknown -method configured: \"$RPCmethod\".\n");
                exit(1);
            }

            if (defined($result)) {
                chomp($result);
            }

            return $result;
        }
    
    
        sub getPassword {
            my ($prompt) = @_;

            ReadMode("noecho");
            print(STDERR $prompt);
            my $pw = <STDIN>;
            chomp($pw);
            ReadMode("original");
            return $pw;
        }
    
    
        sub blockReward {
            my ($b) = @_;

            return 50 / (2 ** int(($b + 1) / 210000));
        }
    
