#! /usr/bin/perl


    #   NOTE: This program was automatically generated by the Nuweb
    #   literate programming tool.  It is not intended to be modified
    #   directly.  If you wish to modify the code or use it in another
    #   project, you should start with the master, which is kept in the
    #   file blockchain_tools.w in the public GitHub repository:
    #       https://github.com/Fourmilab/blockchain_tools.git
    #   and is documented in the file blockchain_tools.pdf in the root directory
    #   of that repository.

    #
    #   Build 818  2021-10-24 21:02


    
        require 5;
        use strict;
        use warnings;
        use utf8;

        use constant FALSE => 0;
        use constant TRUE => 1;
    

    #   Configured HotBits access
    my $HotBits_API_key = "Pseudorandom";
    my $HotBits_Query = "https://www.fourmilab.ch/cgi-bin/Hotbits.api?nbytes=[NBYTES]&fmt=hex&apikey=[APIKEY]";

    use Bitcoin::Crypto::Key::Private;
    use Bitcoin::Crypto::Key::Public;
    use Bitcoin::BIP39 qw(entropy_to_bip39_mnemonic bip39_mnemonic_to_entropy);
    use Digest::SHA qw(sha256 sha256_hex);
    use Digest::SHA3 qw(sha3_256_hex);
    use Crypt::CBC;
    use Crypt::Digest::Keccak256 qw(keccak256_hex);
    use Crypt::Random::Seed;
    use MIME::Base64;
    use LWP::Simple;
    use Getopt::Long qw(GetOptionsFromArray);
    use Data::Dumper;

    my $opt_Format = "";        # Format for generated keys

    my $repeat = 1;             # Repeat command this number of times
    my $outputFile = "-";       # Output file for keys
    my $testMode = 0;           # Bit-coded test modes
    my @seeds;                 # Stack of seeds

    my %options = (
        "aesenc"    =>  \&arg_aesenc,
        "aesdec"    =>  \&arg_aesdec,
        "bindump=s" =>  \&arg_bindump,
        "binfile=s" =>  \&arg_binfile,
        "btc"       =>  \&arg_btc,
        "clear"     =>  \&arg_clear,
        "drop"      =>  \&arg_drop,
        "dump"      =>  \&arg_dump,
        "dup"       =>  \&arg_dup,
        "eth"       =>  \&arg_eth,
        "format=s"  =>  \$opt_Format,
        "hbapik=s"  =>  \$HotBits_API_key,
        "help"      =>  \&showHelp,
        "hexfile=s" =>  \&arg_hexfile,
        "hotbits"   =>  \&arg_hotbits,
        "inter"     =>  \&arg_inter,
        "minigen"   =>  \&arg_minigen,
        "minikey=s" =>  \&arg_minikey,
        "mnemonic"  =>  \&arg_mnemonic,

        "not"       =>  \&arg_not,
        "outfile=s" =>  \&arg_outfile,
        "over"      =>  \&arg_over,
        "p"         =>  \&arg_printtop,
        "phrase=s"  =>  \&arg_phrase,
        "pick=i"    =>  \&arg_pick,
        "pseudo"    =>  \&arg_pseudo,
        "pseudoseed"=>  \&arg_pseudoseed,
        "random"    =>  \&arg_random,
        "repeat=i"  =>  \$repeat,
        "roll=i"    =>  \&arg_roll,
        "rot"       =>  \&arg_rot,
        "rrot"      =>  \&arg_rrot,
        "seed=s"    =>  \&arg_seed,
        "sha2"      =>  \&arg_sha2,
        "sha3"      =>  \&arg_sha3,
        "shuffle"   =>  \&arg_shuffle,
        "swap"      =>  \&arg_swap,
        "test"      =>  \&arg_test,
        "testall"   =>  \&arg_testall,
        "testmode=i" => \$testMode,
        "type=s"    =>  sub { print("$_[1]\n"); },
        "urandom"   =>  \&arg_urandom,
        "wif=s"     =>  \&arg_wif,
        "xor"       =>  \&arg_xor,
        "zero"      =>  \&arg_zero
    );

    processConfiguration();

    GetOptions(
               %options
              ) ||
        die("Invalid command line option");

    if ($testMode & 4) {
        print("Modules used\n  ",
              join("\n  ", map { s|/|::|g;
                                 s/\.pm$//; $_
                               }
                           sort(keys(%INC))));
    }

    #   Shared utility functions
    
        sub readHexfile {
            my ($fname) = @_;

            my $data = "";
            my $ignore = TRUE;
            my $hex = qr/[\dA-Fa-f]/;

            open(FI, "<$fname") || die("Cannot open $fname");
            while (my $l = <FI>) {
                chomp($l);
                $l =~ s/\s+//g;
                my $isHex = $l =~ m/^$hex+$/;
                if ($ignore) {
                    if ($isHex && (length($l) >= 32)) {
                        $ignore = FALSE;
                    }
                }
                if (!$ignore) {
                    if ($isHex) {
                        $data .= $l;
                    } else {
                        last;
                    }
                }
            }
            close(FI);
            if (length($data) & 1) {
                die("Number of hexadecimal digits is odd");
            }
            return $data;
        }
    
    
        use Math::Random::MT;

        my $randGen;                    # Pseudorandom number generator

        sub randInit {
            if (!defined($randGen)) {
                my (@seed, $rbuf);

                my $rgen = Crypt::Random::Seed->new(NonBlocking => 1);
                $rbuf = $rgen->random_bytes(624 * 4);
                @seed = unpack("L4", $rbuf);
                $randGen = Math::Random::MT->new(@seed);
            }
        }
    
        sub randNext {
            my ($n) = @_;

            return $randGen->rand($n);
        }
    
    
        sub processCommand {
            my ($command, $interactive) = @_;

            my ($verb, $noun) = ("", "");
            $command =~ s/\s+$//;
            #   Ignore blank lines and comments
            if (($command ne "") && ($command !~ m/^\s*#/)) {
                $command =~ m/^\s*(\w+)(?:\s+(\S.*?))?\s*$/ ||
                    die("Unable to parse command \"$command\"\n");
                ($verb, $noun) = ($1, $2);
                my $inop = TRUE;
                foreach my $op (keys(%options)) {
                    $op =~ s/(?:\+|=\w+)$//;
                    if ($op eq $verb) {
                        $inop = FALSE;
                        last;
                    }
                }
                if ($inop) {
                    if ($interactive) {
                        return ("", "") if ($verb =~ m/^(?:en|ex|qu)/);
                        print("Unknown command/option \"$verb\".\n");
                        return ("?", "");
                    } else {
                        return ("", "");
                    }
                }
                $noun = "" if (!defined($noun));
                my @optarr = ( "-$verb" );
                if ($noun ne "") {
                    push(@optarr, $noun);
                }
                if (!GetOptionsFromArray(\@optarr, %options)) {
                    if ($interactive) {
                        print("Error in command \"$command\".\n");
                    }
                }
            }
            return ($verb, $noun);
        }
    
        my $interactive = FALSE;

        sub arg_inter {
            $interactive = TRUE;
            while (TRUE) {
                print("> ");
                my $l = <> || last;
                chomp($l);
                if ($l !~ m/^\s*$/) {
                    my ($v, $n) = (" ", "");
                    eval {
                        ($v, $n) = processCommand($l, TRUE);
                    };
                    last if ($v eq "");
                }
            }
            $interactive = FALSE;
        }
    
        sub processCommandFile {
            my ($fname) = @_;

            open(CI, "<$fname") ||
                die("Cannot open command file $fname");

            while (my $l = <CI>) {
                chomp($l);
                my ($v, $n) = processCommand($l, FALSE);
            }
            close(CI);
        }
    
        sub processConfiguration {
            if (-f "blockchain_tools.conf") {
                processCommandFile("blockchain_tools.conf");
            }
            my $progName = "perl/blockchain_address.pl";
            $progName =~ m|^(?:[^/]*/)?(\w+)\.\w+$| ||
                die("Cannot extract program name from $progName");
            $progName = $1;
            if (-f "$progName.conf") {
                processCommandFile("$progName.conf");
            }
        }
    

    #   Local functions
    
        
            sub arg_aesenc {
                stackCheck(2);
                my $key = hexToBytes(pop(@seeds));
                my $plaintext = hexToBytes(pop(@seeds));
                my $crypt = Crypt::CBC->new(
                                -chain_mode => "cfb",
                                -pbkdf  => "none",
                                -header => "none",
                                -key    => $key,
                                -iv     => substr(sha256($key), 0, 16),
                                -cipher => "Crypt::OpenSSL::AES");
                push(@seeds, bytesToHex($crypt->encrypt($plaintext)));
            }
        
        
            sub arg_aesdec {
                stackCheck(2);
                my $key = hexToBytes(pop(@seeds));
                my $codetext = hexToBytes(pop(@seeds));
                my $crypt = Crypt::CBC->new(
                                -chain_mode => "cfb",
                                -pbkdf  => "none",
                                -header => "none",
                                -key    => $key,
                                -iv     => substr(sha256($key), 0, 16),
                                -cipher => "Crypt::OpenSSL::AES");
                push(@seeds, bytesToHex($crypt->decrypt($codetext)));
            }
        
        
            sub arg_bindump {
                my ($name, $value) = @_;

                if (open(BO, ">$value")) {
                    foreach my $seed (@seeds) {
                        print(BO hexToBytes($seed));
                    }
                    close(BO);
                } else {
                    print("Cannot create file $value.\n");
                }
            }
        
        
            sub arg_binfile {
                my ($name, $value) = @_;

                open(BI, "<$value") || die("Cannot open $value");
                my $dat;
                while (read(BI, $dat, 32) == 32) {
                    push(@seeds, bytesToHex($dat));
                }
                close(BI);
            }
        
        
            sub arg_btc {
                my ($name, $value) = @_;
                stackCheck($repeat);

                my $keyn = 1;
                my $keep = ($opt_Format =~ m/k/);
                my @kept;
                
                    if ($outputFile ne "-") {
                        open(OFILE, ">$outputFile") || die("Cannot create file $outputFile");
                        select OFILE;
                    }
                
                
                    for (my $rpt = 0; $rpt < $repeat; $rpt++) {
                
                    my $seed = pop(@seeds);
                    if ($keep) {
                        push(@kept, $seed);
                    }
                    my ($priv, $pub) = genBtcAddress($seed, $opt_Format, 1);
                    print(editBtcAddress($priv, $pub, $opt_Format, $keyn++, ""));
                
                    }
                
                
                    if ($outputFile ne "-") {
                        select STDOUT;
                        close(OFILE);
                    }
                
                if ($keep) {
                    
                        for (my $rpt = 0; $rpt < $repeat; $rpt++) {
                    
                        push(@seeds, pop(@kept));
                    
                        }
                    
                }
            }
        
        
            sub arg_clear {
                @seeds = ();
            }
        
        
            sub arg_drop {
                stackCheck(1);
                pop(@seeds);
            }
        
        
            sub arg_dump {
                
                    if ($outputFile ne "-") {
                        open(OFILE, ">$outputFile") || die("Cannot create file $outputFile");
                        select OFILE;
                    }
                
                if ($outputFile eq "-") {
                    print("  ", join("\n  ", reverse(@seeds)), "\n");
                } else {
                    print(join("\n", @seeds), "\n");
                }
                
                    if ($outputFile ne "-") {
                        select STDOUT;
                        close(OFILE);
                    }
                
            }
        
        
            sub arg_dup {
                stackCheck(1);
                push(@seeds, $seeds[$#seeds]);
            }
        
        
            sub arg_eth {
                my ($name, $value) = @_;
                stackCheck($repeat);

                my $keyn = 1;
                my $keep = ($opt_Format =~ m/k/);
                my @kept;
                
                    if ($outputFile ne "-") {
                        open(OFILE, ">$outputFile") || die("Cannot create file $outputFile");
                        select OFILE;
                    }
                
                
                    for (my $rpt = 0; $rpt < $repeat; $rpt++) {
                
                    my $seed = pop(@seeds);
                    if ($keep) {
                        push(@kept, $seed);
                    }
                    my ($priv, $pub) = genEthAddress($seed, $opt_Format, 1);
                    print(editEthAddress($priv, $pub, $opt_Format, $keyn++));
                
                    }
                
                
                    if ($outputFile ne "-") {
                        select STDOUT;
                        close(OFILE);
                    }
                
                if ($keep) {
                    
                        for (my $rpt = 0; $rpt < $repeat; $rpt++) {
                    
                        push(@seeds, pop(@kept));
                    
                        }
                    
                }
            }
        
        
            sub arg_hexfile {
                my ($name, $value) = @_;

                my $hf = readHexfile($value);
                while ($hf =~ s/^([\dA-F]{64})//i) {
                    push(@seeds, uc($1));
                }
            }
        
        
            sub arg_hotbits {
                my $n = 32 * $repeat;
                my $hbq = $HotBits_Query;
                $hbq =~ s/\[NBYTES\]/$n/;
                $hbq =~ s/\[APIKEY\]/$HotBits_API_key/;
                my $hbr = get($hbq);
                $hbr =~ m:<pre>(.*?\w+.*?)</pre>:s || die("Cannot parse HotBits reply: $hbr");
                my $hf = $1;
                $hf =~ s/\W//g;
                while ($hf =~ s/^([\dA-F]{64})//i) {
                    push(@seeds, $1);
                }
            }
        
        
            sub arg_minigen {
                my $keyn = 1;
                my $keep = ($opt_Format =~ m/k/);
                my @kept;
                
                    if ($outputFile ne "-") {
                        open(OFILE, ">$outputFile") || die("Cannot create file $outputFile");
                        select OFILE;
                    }
                
                
                    for (my $rpt = 0; $rpt < $repeat; $rpt++) {
                
                    my ($minikey, $privkey) = findMiniKey();
                    if ($keep) {
                        push(@kept, $privkey);
                    }
                    my ($priv, $pub) = genBtcAddress($privkey, $opt_Format, 1);
                    print(editBtcAddress($priv, $pub, $opt_Format, $keyn++, $minikey));
                
                    }
                
                
                    if ($outputFile ne "-") {
                        select STDOUT;
                        close(OFILE);
                    }
                
                if ($keep) {
                    
                        for (my $rpt = 0; $rpt < $repeat; $rpt++) {
                    
                        push(@seeds, pop(@kept));
                    
                        }
                    
                }
            }
        
        
            sub arg_minikey {
                my ($name, $value) = @_;

                my $goof = "";
                if ($value =~ m/^S/) {
                    if (($value =~ m/^S([\w]{29})$/) ||
                        ($value =~ m/^S([\w]{21})$/)) {
                        my $adr = $1;
                        if ($adr =~ m/^[1-9A-HJ-NP-Za-km-z]+$/) {
                            if (sha256_hex("$value?") =~ m/^00/) {
                                push(@seeds, uc(sha256_hex($value)));
                            } else {
                                $goof = "bad checksum";
                            }
                        } else {
                            $goof = "invalid character in key";
                        }
                    } else {
                        $goof = "incorrect length";
                    }
                } else {
                    $goof = "does not start with \"S\"";
                }
                if ($goof) {
                    print("Invalid mini key: $goof.\n");
                }
            }
        
        
            sub arg_mnemonic {
                stackCheck(1);
                print(BIP39encode("  ", pop(@seeds), 64));
            }
        
        
            sub arg_not {
                stackCheck(1);
                my $b = hexToBytes(pop(@seeds));
                my $bi = "";
                for (my $i = 0; $i < bytes::length($b); $i++) {
                    $bi .= sprintf("%02X", ord(bytes::substr($b, $i, 1)) ^ 0xFF);
                }
                push(@seeds, $bi);
            }
        
        
            sub arg_outfile {
                my ($name, $value) = @_;

                $outputFile = $value;
            }
        
        
            sub arg_over {
                stackCheck(2);
                push(@seeds, $seeds[$#seeds - 1]);
            }
        
        
            sub arg_pick {
                my ($name, $value) = @_;

                stackCheck($value + 1);
                push(@seeds, $seeds[$#seeds - $value]);
            }
        
        
            sub arg_pseudo {
                randInit();
                
                    for (my $rpt = 0; $rpt < $repeat; $rpt++) {
                
                    my $s = "";
                    for (my $i = 0; $i < 32; $i++) {
                        $s .= sprintf("%02X", randNext(256));
                    }
                    push(@seeds, $s);
                
                    }
                
            }
        
        
            sub arg_pseudoseed {
                my $orepeat = $repeat;
                if ($repeat > 78) {
                    $repeat = 78;
                }
                stackCheck($repeat);

                my $allbytes = "";
                
                    for (my $rpt = 0; $rpt < $repeat; $rpt++) {
                
                    $allbytes .= hexToBytes(pop(@seeds));
                
                    }
                

                my @pseed = unpack("L4", $allbytes);
                $randGen = Math::Random::MT->new(@pseed);
                $repeat = $orepeat;
            }
        
        
            sub arg_phrase {
                my ($name, $value) = @_;

                my $seed = bip39_mnemonic_to_entropy(
                    mnemonic => $value,
                    encoding => "hex");
                push(@seeds, uc($seed));
            }
        
        
            sub arg_printtop {
                if (scalar(@seeds) > 0) {
                    print("  $seeds[-1]\n");
                } else {
                    print("Stack empty.\n");
                }
            }
        
        
            sub arg_random {
                my $n = 32 * $repeat;
                my $rgen = new Crypt::Random::Seed;
                if (defined($rgen)) {
                    my $rbytes = $rgen->random_bytes($n);
                    while ($rbytes =~ s/^(.{32})//s) {
                        my $hn = $1;
                        push(@seeds, bytesToHex($hn));
                    }
                } else {
                    print("No strong random generator available.");
                }
            }
        
        
            sub arg_roll {
                my ($name, $value) = @_;

                stackCheck($value + 1);
                my $itemn = splice(@seeds, -($value + 1), 1);
                push(@seeds, $itemn);
            }
        
        
            sub arg_rot {
                stackCheck(3);
                my $item3 = splice(@seeds, -3, 1);
                push(@seeds, $item3);
            }
        
        
            sub arg_rrot {
                stackCheck(3);
                my $item1 = pop(@seeds);
                splice(@seeds, 2, 0, $item1);
            }
        
        
            sub arg_seed {
                my ($name, $value) = @_;

                $value =~ s/^0x//i;
                if ($value !~ m/^[\dA-F]{64}/i) {
                    die("Invalid seed.  Must be 64 hexadecimal digits");
                }
                push(@seeds, uc($value));
            }
        
        
            sub arg_sha2 {
                stackCheck($repeat);

                my $bytes = "";
                
                    for (my $rpt = 0; $rpt < $repeat; $rpt++) {
                
                    $bytes .= hexToBytes(pop(@seeds));
                
                    }
                
                my $sha2_256 = uc(sha256_hex($bytes));
                push(@seeds, $sha2_256);
            }
        
        
            sub arg_sha3 {
                stackCheck($repeat);

                my $bytes = "";
                
                    for (my $rpt = 0; $rpt < $repeat; $rpt++) {
                
                    $bytes .= hexToBytes(pop(@seeds));
                
                    }
                
                my $sha3_256 = uc(sha3_256_hex($bytes));
                push(@seeds, $sha3_256);
            }
        
        
            sub arg_shuffle {
                stackCheck($repeat);

                my $allbytes = "";
                
                    for (my $rpt = 0; $rpt < $repeat; $rpt++) {
                
                    $allbytes .= hexToBytes(pop(@seeds));
                
                    }
                
                my $sbytes = bytesToHex(shuffleBytes($allbytes));
                while ($sbytes =~ s/^(\w{64})//) {
                    push(@seeds, $1);
                }
            }
        
        
            sub arg_swap {
                my ($name, $value) = @_;

                stackCheck(2);
                my $itemn = splice(@seeds, -2, 1);
                push(@seeds, $itemn);
            }
        
        
            sub arg_test {
                stackCheck($repeat);

                my $catseed = join("", @seeds[0 .. ($repeat - 1)]);
                my $r = "Randomness analysis:\n";
                my $ent_analysis = `echo $catseed | xxd -r -p - | ent -b`;
                $ent_analysis =~ s/\n\n/\n/gs;
                $ent_analysis =~ s/^/    /mg;
                $ent_analysis =~ s/(of this|would exceed)/  $1/gs;
                print("$ent_analysis");
            }
        
        
            sub arg_testall {
                stackCheck(1);
                my $catseed = join("", @seeds);
                my $r = "Randomness analysis:\n";
                my $ent_analysis = `echo $catseed | xxd -r -p - | ent -b`;
                $ent_analysis =~ s/\n\n/\n/gs;
                $ent_analysis =~ s/^/    /mg;
                $ent_analysis =~ s/(of this|would exceed)/  $1/gs;
                print("$ent_analysis");
            }
        
        
            sub arg_urandom {
                my $n = 32 * $repeat;
                my $rgen = Crypt::Random::Seed->new(NonBlocking => 1);
                if (defined($rgen)) {
                    my $rbytes = $rgen->random_bytes($n);
                    while ($rbytes =~ s/^(.{32})//s) {
                        my $hn = $1;
                        push(@seeds, bytesToHex($hn));
                    }
                } else {
                    print("No fast random generator available.");
                }
            }
        
        
            sub arg_wif {
                my ($name, $value) = @_;

                my $priv = Bitcoin::Crypto::Key::Private->from_wif($value);
                my $seed = $priv->to_hex();
                push(@seeds, uc($seed));
            }
        
        
            sub arg_xor {
                stackCheck(2);
                my $ol = hexToBytes(pop(@seeds));
                my $or = hexToBytes(pop(@seeds));
                if (bytes::length($ol) != bytes::length($or)) {
                    print("-xor: arguments are different lengths.\n");
                    exit(1);
                }
                my $rbytes;
                for (my $i = 0; $i < bytes::length($ol); $i++) {
                    $rbytes .= chr(ord(bytes::substr($ol, $i, 1))) ^
                               chr(ord(bytes::substr($or, $i, 1)));
                }
                push(@seeds, bytesToHex($rbytes));
            }
        
        
            sub arg_zero {
                
                    for (my $rpt = 0; $rpt < $repeat; $rpt++) {
                
                    push(@seeds, "00" x 32);
                
                    }
                
             }
        
    
    
        sub hexToBytes {
            my ($hex) = @_;

            my $bytes;
            while ($hex =~ s/^([\dA-F]{2})//i) {
                $bytes .= chr(hex($1));
            }
            return $bytes;
        }
    
    
        sub bytesToHex {
            my ($bytes) = @_;

            my $hex;
            for (my $i = 0; $i < bytes::length($bytes); $i++) {
                $hex .= sprintf("%02X", ord(bytes::substr($bytes, $i, 1)));
            }
            return $hex;
        }
    
    
        sub genBtcAddress {
            my ($seed, $mode, $n) = @_;

            if ($seed !~ m/^[\dA-F]{64}/i) {
                die("Invalid seed.  Must be 64 hexadecimal digits");
            }
    
            my $priv = Bitcoin::Crypto::Key::Private->from_hex($seed);
    
            my $dhex = uc($priv->to_hex());
            if ($dhex ne $seed) {
                die("Verify failed: Decoded " . $priv->to_hex() . "\n" .
                    "               Encoded $seed");
            }
    
            my $pub = $priv->get_public_key();

            return ($priv, $pub);
        }
    
    
        sub editBtcAddress {
            my ($priv, $pub, $mode, $n, $minikey) = @_;
    
            my $phex = uc($priv->to_hex());
            my $pb64 = encode_base64($priv->to_bytes());
            chomp($pb64);
    
            $priv->set_compressed(TRUE);
            my $WIFc = $priv->to_wif();

            $priv->set_compressed(FALSE);
            my $WIFu = $priv->to_wif();
    
            $pub->set_compressed(TRUE);
            my $pub_legacy = $pub->get_legacy_address();
            my $pub_compat = $pub->get_compat_address();
            my $pub_segwit = $pub->get_segwit_address();
            my $pub_hex = uc($pub->to_hex());

            $pub->set_compressed(FALSE);
            my $pub_legacy_u = $pub->get_legacy_address();
            my $pub_compat_u = $pub->get_compat_address();
            my $pub_segwit_u = $pub->get_segwit_address();
            my $pub_hex_u = uc($pub->to_hex());
    
            my $r = "";

            if ($mode =~ m/^CSV(\w*)$/) {
                my $CSVmodes = $1;

                #   Comma-separated value file

                my $privK = $WIFc;
                if ($CSVmodes =~ m/b/i) {       # b     Exclude private key
                    $privK = "";
                }
                if ($CSVmodes =~ m/q/i) {       # q     Uncompressed private key
                    $privK = $WIFu;
                }
                my $comp = $CSVmodes !~ m/u/i;  # u     Uncompressed public address
                my $pubK = $comp ? $pub_legacy : $pub_legacy_u;
                if ($CSVmodes =~ m/c/i) {       # c     Compatible ("3") public address
                    $pubK = $comp ? $pub_compat : $pub_compat_u;
                } elsif ($CSVmodes =~ m/s/i) {  # s     Segwit "bc1" public address
                    $pubK = $comp ? $pub_segwit : $pub_segwit_u;
                }

                my $mk = "";
                #   If generated from mini key, append it to CSV record
                if ($minikey && ($CSVmodes !~ m/b/i)) {
                    $mk = ",,\"$minikey\"";
                }
                $r = "$n,\"$pubK\",\"$privK\"$mk\n";

            } else {
    
                #   Human-readable output

                #   Display private key seed in hexadecimal

                $r .= "Private key:\n";
                $r .= "    Hexadecimal:      $phex\n";
                $r .= "    Base64:           $pb64\n";
                $r .= BIP39encode("    BIP39:            ", $phex, 64);

                #   Display private key in both compressed and
                #   uncompressed  formats.

                $r .= "    WIF compressed:   $WIFc\n";
                $r .= "    WIF uncompressed: $WIFu\n";
                $r .= "    Minikey:          $minikey\n" if $minikey;

                #   Display public Bitcoin address in various formats

                $r .= "\nPublic Bitcoin address:\n" .
                      "  Compressed:\n" .
                      "    Legacy:  $pub_legacy\n" .
                      "    Compat:  $pub_compat\n" .
                      "    Segwit:  $pub_segwit\n" .
                      "    Hex:     $pub_hex\n" .
                      "  Uncompressed:\n" .
                      "    Legacy:  $pub_legacy_u\n" .
                      "    Compat:  $pub_compat_u\n" .
                      "    Segwit:  $pub_segwit_u\n" .
                      "    Hex:     $pub_hex_u\n";

                return $r;
            }
        }
    
    
        sub findMiniKey {
            my $b58r = "23456789ABCDEFGHJKLMNPQRSTUVWXYZabcdefghijkmnopqrstuvwxyz";
            my $b58rl = length($b58r);

            randInit();
            my $rgen;
            my $rbuf = "";
            if (!($testMode & 1)) {
                $rgen = Crypt::Random::Seed->new(NonBlocking => 1);
            }

            my $mk;
            do {
                $mk = "S";
                for my $i (1 .. 29) {
                    my $ri;
                    if ($rgen) {
                        do {
                            $ri = randNext(64);
                            if (defined($rgen)) {
                                if ($rbuf eq "") {
                                    $rbuf = $rgen->random_bytes(64);
                                }
                                $rbuf =~ s/^(.)//s;
                                my $rch = $1;
                                $ri ^= ord($rch) & 63;
                            }
                        } while ($ri >= $b58rl);
                    } else {
                        $ri = randNext($b58rl);
                    }
                    $mk .= substr($b58r, $ri, 1);
                }
            } while (sha256_hex("$mk?") !~ m/^00/);

            return ($mk, uc(sha256_hex($mk)));
        }
    
    
        sub genEthAddress {
            my ($seed, $mode, $n) = @_;

            if ($seed !~ m/^[\dA-F]{64}/i) {
                die("Invalid seed.  Must be 64 hexadecimal digits");
            }
    
            my $priv = Bitcoin::Crypto::Key::Private->from_hex($seed);
    
            my $dhex = uc($priv->to_hex());
            if ($dhex ne $seed) {
                die("Verify failed: Decoded " . $priv->to_hex() . "\n" .
                    "               Encoded $seed");
            }
    
            my $pub = $priv->get_public_key();

            return ($priv, $pub);
        }
    
    
        sub editEthAddress {
            my ($priv, $pub, $mode, $n) = @_;
    
            my $phex = "0x" . $priv->to_hex();
    
            $pub->set_compressed(FALSE);
            my $pub_hex_u = $pub->to_hex();
            my $pub_addr = "0x" .
                substr(keccak256_hex(hexToBytes(substr($pub_hex_u, 2))), -40);
            my $pub_addrc = computeEthChecksum($pub_addr);
    
            my $r = "";

            if ($mode =~ m/^CSV(\w*)$/) {
                my $CSVmodes = $1;

                my $dpub_addr = ($CSVmodes =~ m/n/i) ? $pub_addr : $pub_addrc;
                my $pkey = ($CSVmodes =~ m/p/i) ? ",\"$pub_hex_u\"" : "";
                if ($CSVmodes =~ m/b/i) {       # b     Exclude private key
                    $phex = "";
                }

                $r = "$n,\"$dpub_addr\",\"$phex\"$pkey\n";

            } else {
    
                #   Human-readable output

                #   Display private key seed in hexadecimal

                $r .= "Private key:\n";
                $r .= "  Hexadecimal: $phex\n";

                #   Display public Ethereum address

                $r .= "\nPublic Ethereum address:\n" .
                      "  Address:     $pub_addr\n" .
                      "  Checksum:    $pub_addrc\n" .
                      "  Public key:  $pub_hex_u\n";

                return $r;
            }
        }
    
    
        sub computeEthChecksum {
            my ($eaddr) = @_;

            my $eal = lc($eaddr);
            #   Strip leading hex specification, if present
            $eal =~ s/^0x//;
            my $eahash = keccak256_hex($eal);
            for (my $i = 0; $i < length($eal); $i++) {
                my $ch = substr($eal, $i, 1);
                if ($ch =~ m/[a-f]/) {
                    if (substr($eahash, $i, 1) =~ m/[89a-f]/) {
                        substr($eal, $i, 1) = uc($ch);
                    }
                }
            }
            return "0x$eal";
        }
    
    
        sub BIP39encode {
            my ($prefix, $seed, $maxlen) = @_;

            my $s = $prefix;
            my $cont = " " x length($prefix);
            my $r = "";
            my $bip39 = entropy_to_bip39_mnemonic( entropy_hex => $seed );
            my @b39 = split(/\s+/, $bip39);
            foreach my $word (@b39) {
                if ((length($s) + length($word)) > $maxlen) {
                    $s =~ s/\s+$//;
                    $r .= "$s\n";
                    $s = $cont;
                }
                $s .= "$word ";
            }
            $s =~ s/\s+$//;
            $r .= "$s\n";
            return $r;
        }
    
    
        sub shuffleBytes {
            my ($in) = @_;

            randInit();
            my @bytes = unpack("C*", $in);

            my $n = scalar(@bytes);
            for (my $i = $n - 1; $i >= 1; $i--) {
                my $j = randNext($i + 1);
                my $temp = $bytes[$j];
                $bytes[$j] = $bytes[$i];
                $bytes[$i] = $temp;
            }

            return pack("C*", @bytes);
        }
    
    
        sub showHelp {
            my $help = <<"    EOD";
    perl blockchain_address.pl [ command... ]
      Commands and arguments:
        -aesenc             Encrypt second item on stack with top of stack key
        -aesdec             Decrypt second item on stack with top of stack key
        -bindump filename   Dump seeds from stack to binary file
        -binfile filename   Load seed(s) from binary file
        -btc                Generate Bitcoin public address/private key from stack seed
        -clear              Clear stack
        -drop               Drop top item on stack
        -dup                Duplicate top item on stack
        -eth                Generate Ethereum address/private key from stack seed
        -format f           Select CSV key output mode: CSVx, where x is
                                Bitcoin:
                                  b   Suppress private key
                                  c   Compatible public address ("3...")
                                  k   Keep addresses on stack
                                  l   Legacy public address ("1...")
                                  q   Uncompressed private key
                                  s   Segwit public address ("bc1...")
                                  u   Uncompressed public address
                                Ethereum:
                                  b   Suppress private key
                                  k   Keep addresses on stack
                                  n   No checksum on public address
                                  p   Include full public key
        -hbapik hbapikey    Specify HotBits API key
        -help               Print this message
        -hexfile filename   Load hexadecimal seed(s) from filename
        -hotbits            Get seed(s) from HotBits, place on stack
        -inter              Process interactive commands
        -minigen            Generate Bitcoin mini private key
        -minikey key        Decode Bitcoin mini private key
        -mnemonic           Generate BIP39 mnemonic phrase from stack top
        -not                Invert stack top
        -outfile filename   Redirect key generation output to file or - for console
        -over               Duplicate second item on stack to top
        -p                  Print top item on stack
        -phrase words...    Specify seed as BIP39 mnemonic phrase
        -pick n             Duplicate the nth item on the stack to top
        -pseudo             Generate pseudorandom seed and push on stack
        -pseudoseed         Set seed for pseudorandom generator
        -random             Obtain a seed from system strong generator, push on stack
        -repeat n           Repeat following commands n times
        -roll n             Rotate item n to top of stack
        -rot                Rotate the top three stack items
        -rrot               Reverse rotate top three stack items
        -seed hex           Push the hexadecimal seed on top of stack
        -sha2               Replace top of stack with its SHA2-256 digest
        -sha3               Replace top of stack with its SHA3-256 digest
        -shuffle            Shuffle bytes on stack
        -swap               Swap the two top items on the stack
        -test               Test stack items for randomness
        -testall            Test entire stack contents for randomness
        -testmode n         Select test modes (0 for production)
        -type Any text      Display text argument on standard output
        -urandom            Obtain a seed from system fast generator, push on stack
        -wif                Push seed extracted from Wallet Input Format private key
        -xor                Bitwise exclusive-or top two stack items
        -zero               Push zeroes on stack
    EOD
            $help =~ s/^    //gm;
            print($help);
            if (!$interactive) {
                exit(0);
            }
        }
    
    
        sub stackCheck {
            my ($required) = @_;

            if ($required > scalar(@seeds)) {
                print("Stack underflow: $required item(s) needed, only " .
                    scalar(@seeds) . " present.\n");
                exit(1) if !$interactive;
                die("Stack underflow");
            }
        }
    
