#! /usr/bin/perl


    #   NOTE: This program was automatically generated by the Nuweb
    #   literate programming tool.  It is not intended to be modified
    #   directly.  If you wish to modify the code or use it in another
    #   project, you should start with the master, which is kept in the
    #   file blockchain_tools.w in the public GitHub repository:
    #       https://github.com/Fourmilab/blockchain_tools.git
    #   and is documented in the file blockchain_tools.pdf in the root directory
    #   of that repository.

    #
    #   Build 818  2021-10-24 21:02


    
        require 5;
        use strict;
        use warnings;
        use utf8;

        use constant FALSE => 0;
        use constant TRUE => 1;
    

    
        my $RPCmethod = "rpc"; # RPC query method: "local", "ssh", "rpc"
        my $RPChost = "localhost";           # Host where bitcoind runs
        my $RPCport = 8332;             # bitcoind RPC query port (standard 8332)
        my $RPCcli = "bitcoin-cli";    # Path to run bitcoin-cli
        my $RPCuser = "myuser";           # RPC user name
        my $RPCpass = "";       # RPC password
    

    use LWP;
    use JSON;
    use Text::CSV qw(csv);
    use Getopt::Long qw(GetOptionsFromArray);
    use POSIX qw(strftime);
    use Term::ReadKey;

    use Data::Dumper;

    my $log_file = "";               # Log file from Address Watch
    my $watch = FALSE;         # Watch for confirmations ?
    my $poll_time = 300;   # Poll time for watch check
    my $testmode = FALSE;                           # Test on recent blockchain transaction
    my $verbose = 0;              # Verbose output ?
    my $confirmed = 6;          # Number of confirmations required

    my %options = (
        
            "clipath=s"     => \$RPCcli,
            "host=s"        => \$RPChost,
            "method=s"      => \$RPCmethod,
            "rpcpass=s"     => \$RPCpass,
            "port=i"        => \$RPCport,
            "user=s"        => \$RPCuser,
        
        "confirmed=i"   => \$confirmed,
        "help"          => \&showHelp,
        "lfile=s"       => \$log_file,
        "poll=i"        => \$poll_time,
        "testmode"      => \$testmode,
        "type=s"        => sub { print("$_[1]\n"); },
        "verbose+"      => \$verbose,
        "watch"         => \$watch
    );

    processConfiguration();

    GetOptions(
        %options
    ) || die("Command line option error");

    my ($txID, $blockHash);

    if ($testmode) {
        my ($nvin, $nvout, $vtotal, $vaddr);
        my $lastBlock = sendRPCcommand([ "getblockcount" ]);
        while (TRUE) {
            print("Searching block $lastBlock\n") if $verbose >= 2;
            ($txID, $blockHash, $nvin, $nvout, $vtotal, $vaddr) = getRecentTransaction($lastBlock);
            if (defined($txID)) {
                print("Testing with transaction: $txID\n  Block: $lastBlock\n");
                print("  Hash:  $blockHash\n") if $blockHash;
                print("  Sending BTC $vtotal to ");
                if ($nvout <= 2) {
                    print("$vaddr\n");
                } else {
                    print("$nvout addresses\n");
                }
                last;
            }
            $lastBlock--;
        }
    } else {

        if (scalar(@ARGV) == 1) {
            my $addr = $ARGV[0];
            if ((length($addr) < 48) || ($addr =~ m/[^\da-f]/i)) {
                if ($log_file eq "") {
                    print("Cannot look up address or label unless log file (-lfile) specified.\n");
                    exit(2);
                }
                my $found = FALSE;

                do {
                    open(LI, "<$log_file") || die("Cannot open log file $log_file");
                    my ($txid, $blockhash);
                    while (my $l = <LI>) {
                        if (($l =~ m/^"[^"]*",$addr,\S+,\S+\s+\S+,\S+,(\S+),(\S+)/) ||
                            ($l =~ m/^"$addr",\S+,\S+,\S+\s+\S+,\S+,(\S+),(\S+)/)
                           ) {
                            ($txid, $blockhash) = ($1, $2);
                            $found = TRUE;
                        }
                    }
                    close(LI);
                    if ($watch && (!$found)) {
                        print("No transaction for this address found in address_watch log.\n" .
                              "Waiting $poll_time seconds before next check.\n")
                            if $verbose;
                        sleep($poll_time);
                    }
                    if ($found) {
                        @ARGV = ( $txid, $blockhash );
                    }
                } while ($watch && (!$found));
                if (!$found) {
                    print("Bitcoin address not found in Address Watch log file.\n");
                    exit(1);
                }
            } else {

                $ARGV[1] = "";
                if (!(hasTXindex())) {
                    print("No transaction index (txindex=1) on Bitcoin node.\n");
                    print("You must supply the block hash for the transaction.\n");
                    exit(1);
                }
            }
        } else {
            if (scalar(@ARGV) < 2) {
                print("usage: confirmation_watch transaction_id block_hash\n");
                exit(0);
            }
        }

        $txID = $ARGV[0];
        $blockHash = $ARGV[1];
    }
    @ARGV = ( );

    if (($RPCmethod eq "rpc") && ($RPCpass eq "")) {
        $RPCpass = getPassword("Bitcoin RPC password: ");
    }

    my $l_confirmations = -1;

    do {
        my $query = [ "getrawtransaction", $txID, "true" ];
        if ($blockHash ne "") {
            push(@$query, $blockHash);
        }
        my $txj = sendRPCcommand($query);
        my $tx = decode_json($txj);

        print(Data::Dumper->Dump([$tx], [ qw(Transaction) ])) if $verbose >= 3;

        my $t_confirmations = $tx->{confirmations};
        my $t_time = $tx->{time};

        if ((!$watch) || ($t_confirmations != $l_confirmations)) {
            $l_confirmations = $t_confirmations;
            #   If confirmation count is greater than 1, set time to
            #   that of the most recent block.
            if ($t_confirmations > 1) {
                my $lastBlock = sendRPCcommand([ "getblockcount" ]);
                my $lbStat = sendRPCcommand([ "getblockstats", $lastBlock, '[ "time" ]' ]);
                if ($lbStat) {
                    my $lbT = decode_json($lbStat);
                    $t_time = $lbT->{time};
                }
            }

            #   Show date and time and number of confirmations
            print(etime($t_time) . "  Confirmations: $t_confirmations\n");

            if (($verbose >= 2) && ($t_confirmations == 1)) {
                #   Number of "vout" items in transaction
                my $t_nvout = scalar(@{$tx->{vout}});
                #   Loop over vout items
                for (my $v = 0; $v < $t_nvout; $v++) {
                    if (defined($tx->{vout}->[$v]->{scriptPubKey}) &&
                        defined($tx->{vout}->[$v]->{scriptPubKey}->{addresses})) {
                        my $v_naddr = scalar(@{$tx->{vout}->[$v]->{scriptPubKey}->{addresses}});
                        my $v_value = $tx->{vout}->[$v]->{value};
                        #   Loop over addresses in vout item
                        for (my $a = 0; $a < $v_naddr; $a++) {
                            #   Show destination addresses and amounts
                            my $a_addr = $tx->{vout}->[$v]->{scriptPubKey}->{addresses}->[$a];
                            printf("  => %-42s  %12.8f\n", $a_addr, $v_value);
                        }
                    }
                }
            }
        }

         if ($watch && ($l_confirmations < $confirmed)) {
            sleep($poll_time);
        }
   } while ($watch && ($l_confirmations < $confirmed));

    
        sub getRecentTransaction {
            my ($blockNo) = @_;

            my $bh = sendRPCcommand([ "getblockhash", "$blockNo" ]);
            print("    Block hash $bh\n") if $verbose;
            my $blk = sendRPCcommand([ "getblock",  $bh, "2" ]);
            my $r = decode_json($blk);

            my $b_hash = $r->{hash};            # Block hash
            my $b_nTx = $r->{nTx};              # Transactions in block

            print("    Block $blockNo " . gmtime($r->{time}) .
                  " Transactions $b_nTx\n") if $verbose >= 2;

            my ($vinmin, $voutmin) = (1e20, 1e20);
            my $strans = -1;
    
            for (my $t = 0; $t < $b_nTx; $t++) {
                #   Transaction ID
                my $t_txid = $r->{tx}->[$t]->{txid};

                my $t_nvin = scalar(@{$r->{tx}->[$t]->{vin}});
                my $t_nvout = scalar(@{$r->{tx}->[$t]->{vout}});

                if ($verbose >= 3) {
                    my $nvinc = (($t_nvin == 1) &&
                                 (defined($r->{tx}->[$t]->{vin}->[0]->{coinbase}))) ? "coinbase" : $t_nvin;
                    print("  $t.  $t_txid  In: $nvinc  Out: $t_nvout\n");
                }

                #   Ignore coinbase transactions
                if (!(($t_nvin == 1) &&
                      (defined($r->{tx}->[$t]->{vin}->[0]->{coinbase})))) {
                    #   Not coinbase
                    if (($t_nvin == 1) && ($t_nvout == 1)) {
                        #   Found a (1, 1): shortcut escape from search
                        $strans = $t;
                        last;
                    }
                    if (($t_nvin <= $vinmin) && ($t_nvout <= $voutmin)) {
                        $strans = $t;
                        $vinmin = $t_nvin;
                        $voutmin = $t_nvout;
                    }
                }
            }
    
            if ($strans >= 0) {
                my $v_total = 0;
                my $v_addr = "";
                #   Loop over vout items to collect addresses and values
                for (my $v = 0; $v < scalar(@{$r->{tx}->[$strans]->{vout}}); $v++) {
                    if (defined($r->{tx}->[$strans]->{vout}->[$v]->{scriptPubKey}) &&
                        defined($r->{tx}->[$strans]->{vout}->[$v]->{scriptPubKey}->{addresses})) {
                        my $v_naddr = scalar(@{$r->{tx}->[$strans]->{vout}->[$v]->{scriptPubKey}->{addresses}});
                        my $v_value = $r->{tx}->[$strans]->{vout}->[$v]->{value};
                        #   Loop over addresses in vout item
                        for (my $a = 0; $a < $v_naddr; $a++) {
                            #   Show destination addresses and amounts
                            my $a_addr = $r->{tx}->[$strans]->{vout}->[$v]->{scriptPubKey}->{addresses}->[$a];
                            printf("$strans.$v  To %-42s Value %12.8f\n",
                                $a_addr, $v_value) if $verbose >= 2;
                            $v_total += $v_value;
                            $v_addr .= ($v_addr ? ", " : "") . $a_addr;
                        }
                    }
                }
                return ($r->{tx}->[$strans]->{txid}, $r->{hash},
                        scalar(@{$r->{tx}->[$strans]->{vin}}),
                        scalar(@{$r->{tx}->[$strans]->{vout}}), $v_total, $v_addr);
            }
            return (undef) x 6;
        }
    
    
        sub hasTXindex {
            my $txindex = FALSE;

            my $ixqs = sendRPCcommand([ "getindexinfo", "txindex" ]);
            if ($ixqs) {
                my $ixq = decode_json($ixqs);
                if ($ixq) {
                    $txindex = $ixq->{txindex}->{synced};
                }
            }
            return $txindex;
        }
    
    
        sub showHelp {
            my $help = <<"    EOD";
    perl confirmation_watch.pl [ option... ] transaction\_id/address/label [ block\_hash ]
      Commands and arguments:
        -confirmed n        Confirmations to deem transaction confirmed
        -help               Print this message
        -lfile filename     Log file from address_watch for looking up labels
        -poll n             Poll for new block every n seconds, 0 = never
        -testmode           Test with a randomly chosen recent transaction
        -type Any text      Display text argument on standard output
        -verbose            Print debug information, more for every -verbose
        -watch              Poll waiting for -confirmed confirmations
      
      Bitcoin API access configuration options:
        -clipath path       Path name to execute bitcoin-cli command line utility
        -host hostname      Host (name or IP address) where Bitcoin Core runs
        -method which       Query method: local, rpc, ssh
        -rpcpass "text"     Bitcoin RPC API password
        -port n             Port for RPC API requests (default 8332)
        -user userid        User name for requests via ssh
    EOD
            $help =~ s/^    //gm;
            print($help);
            exit(0);
        }
    

    
        sub etime {
            my ($t) = @_;

            return strftime("%F %T", gmtime($t));
        }
    
    
        sub processCommand {
            my ($command, $interactive) = @_;

            my ($verb, $noun) = ("", "");
            $command =~ s/\s+$//;
            #   Ignore blank lines and comments
            if (($command ne "") && ($command !~ m/^\s*#/)) {
                $command =~ m/^\s*(\w+)(?:\s+(\S.*?))?\s*$/ ||
                    die("Unable to parse command \"$command\"\n");
                ($verb, $noun) = ($1, $2);
                my $inop = TRUE;
                foreach my $op (keys(%options)) {
                    $op =~ s/(?:\+|=\w+)$//;
                    if ($op eq $verb) {
                        $inop = FALSE;
                        last;
                    }
                }
                if ($inop) {
                    if ($interactive) {
                        return ("", "") if ($verb =~ m/^(?:en|ex|qu)/);
                        print("Unknown command/option \"$verb\".\n");
                        return ("?", "");
                    } else {
                        return ("", "");
                    }
                }
                $noun = "" if (!defined($noun));
                my @optarr = ( "-$verb" );
                if ($noun ne "") {
                    push(@optarr, $noun);
                }
                if (!GetOptionsFromArray(\@optarr, %options)) {
                    if ($interactive) {
                        print("Error in command \"$command\".\n");
                    }
                }
            }
            return ($verb, $noun);
        }
    
        my $interactive = FALSE;

        sub arg_inter {
            $interactive = TRUE;
            while (TRUE) {
                print("> ");
                my $l = <> || last;
                chomp($l);
                if ($l !~ m/^\s*$/) {
                    my ($v, $n) = (" ", "");
                    eval {
                        ($v, $n) = processCommand($l, TRUE);
                    };
                    last if ($v eq "");
                }
            }
            $interactive = FALSE;
        }
    
        sub processCommandFile {
            my ($fname) = @_;

            open(CI, "<$fname") ||
                die("Cannot open command file $fname");

            while (my $l = <CI>) {
                chomp($l);
                my ($v, $n) = processCommand($l, FALSE);
            }
            close(CI);
        }
    
        sub processConfiguration {
            if (-f "blockchain_tools.conf") {
                processCommandFile("blockchain_tools.conf");
            }
            my $progName = "perl/confirmation_watch.pl";
            $progName =~ m|^(?:[^/]*/)?(\w+)\.\w+$| ||
                die("Cannot extract program name from $progName");
            $progName = $1;
            if (-f "$progName.conf") {
                processCommandFile("$progName.conf");
            }
        }
    
    
        sub sendRPCcommand {
            my ($args) = @_;

            my $result;

            if ($RPCmethod eq "local") {
                
                    map({ s/^(\[.*?\])$/'$1'/ } @$args);
                    my $cmd = join(" ", @$args);
                    $result = `$RPCcli $cmd 2>&1`;

                

            } elsif ($RPCmethod eq "ssh") {
                
                    map({ s/^(\[.*?\])$/'$1'/ } @$args);
                    my $cmd = join(" ", @$args);
                    $cmd =~ s/"/\\"/g;
                    $result = `ssh $RPChost $RPCcli \"$cmd\" 2>&1`;
                

             } elsif ($RPCmethod eq "rpc") {
                
                    my $method = shift(@$args);
                
                    for (my $i = 0; $i < scalar(@$args); $i++) {
                        if ($args->[$i] !~ m/^(?:true|false|null|[\d\.]+|".*"|\[.*?\])$/) {
                            my $s = $args->[$i];
                            $s =~ s/"/\\"/g;
                            $args->[$i] = "\"$s\"";
                        }
                    }
                
                    my $params = join(",\n        ", @$args);
                    my $request = LWP::UserAgent->new();
                    $request->agent("trans_watch");
                    #   Specify requester's credentials, including user and password
                    $request->credentials("$RPChost:$RPCport", "jsonrpc",
                        $RPCuser, $RPCpass);
                    #   Compose JSON query to be sent via POST
                    my $query = <<"                EOD";
                {
                "jsonrpc": "1.0",
                "id": "trans_watch",
                "method": "$method",
                "params": [
                $params
                ]
                }
                EOD
                
                    my $rq = HTTP::Request->new("POST",
                                                "http://$RPChost:$RPCport/",
                                                [ "Content-Type" => "text/plain" ],
                                                $query);
                    my $reply = $request->request($rq);
                
                    if ($reply->{_rc} == 200) {
                        $result = $reply->{_content};
                        $result =~ s/^\{"result":(.*?)(,"error":[^\{]+\})$/$1/ ||
                            die("Cannot extract RPC result");
                        my $errstat = $2;
                        if ($errstat !~ m/"error"\s*:\s*null/) {
                            $result = undef;
                        }
                    }
                

           } else {
                print(STDERR "Unknown -method configured: \"$RPCmethod\".\n");
                exit(1);
            }

            if (defined($result)) {
                chomp($result);
            }

            return $result;
        }
    
    
        sub getPassword {
            my ($prompt) = @_;

            ReadMode("noecho");
            print(STDERR $prompt);
            my $pw = <STDIN>;
            chomp($pw);
            ReadMode("original");
            return $pw;
        }
    
