#! /usr/bin/perl


    #   NOTE: This program was automatically generated by the Nuweb
    #   literate programming tool.  It is not intended to be modified
    #   directly.  If you wish to modify the code or use it in another
    #   project, you should start with the master, which is kept in the
    #   file blockchain_tools.w in the public GitHub repository:
    #       https://github.com/Fourmilab/blockchain_tools.git
    #   and is documented in the file blockchain_tools.pdf in the root directory
    #   of that repository.

    #
    #   Build 818  2021-10-24 21:02


    
        require 5;
        use strict;
        use warnings;
        use utf8;

        use constant FALSE => 0;
        use constant TRUE => 1;
    

    
        my $RPCmethod = "rpc"; # RPC query method: "local", "ssh", "rpc"
        my $RPChost = "localhost";           # Host where bitcoind runs
        my $RPCport = 8332;             # bitcoind RPC query port (standard 8332)
        my $RPCcli = "bitcoin-cli";    # Path to run bitcoin-cli
        my $RPCuser = "myuser";           # RPC user name
        my $RPCpass = "";       # RPC password
    

    use LWP;
    use JSON;
    use Text::CSV qw(csv);
    use Getopt::Long qw(GetOptionsFromArray);
    use POSIX qw(strftime);
    use Term::ReadKey;

    use Data::Dumper;

    my $conf_target = 6;        # Confirmation target in blocks
    my $fee_file = "";                              # Fee watch log file
    my $poll_time = 300;   # Poll time for watch check
    my $quiet = FALSE;                              # Suppress console output
    my $verbose = 0;              # Verbose output ?

    my %options = (
        
            "clipath=s"     => \$RPCcli,
            "host=s"        => \$RPChost,
            "method=s"      => \$RPCmethod,
            "rpcpass=s"     => \$RPCpass,
            "port=i"        => \$RPCport,
            "user=s"        => \$RPCuser,
        
        "confirmed=i"   => \$conf_target,
        "ffile=s"       => \$fee_file,
        "help"          => \&showHelp,
        "poll=i"        => \$poll_time,
        "quiet"         => \$quiet,
        "type=s"        =>  sub { print("$_[1]\n"); },
        "verbose+"      => \$verbose
    );

    processConfiguration();

    GetOptions(
        %options
    ) || die("Command line option error");

    if (($RPCmethod eq "rpc") && ($RPCpass eq "")) {
        $RPCpass = getPassword("Bitcoin RPC password: ");
    }

    my $block_start = -1;               # Last block processed
    my $lastfee = -1;                   # Last estimated fee

    while (TRUE) {
        my $t = time();
        my $wait = $poll_time - ($t % $poll_time);
        print("Waiting $wait seconds until next poll.\n") if $verbose;
        sleep($wait);
        $t = time();

        my $efj = sendRPCcommand([ "estimatesmartfee", $conf_target ]);
        my $ef = decode_json($efj);
        print(Data::Dumper->Dump([$ef], [ qw(estimatesmartfee) ])) if $verbose >= 2;

        my $estimatedFee = $ef->{feerate};

        if (!$quiet) {
            my $feediff = "";
            if ($lastfee >= 0) {
                if ($lastfee != $estimatedFee) {
                    $feediff = sprintf("  %+.8f  %+.2f%%",
                        $estimatedFee - $lastfee,
                        100 * (($estimatedFee - $lastfee) / $lastfee));
                }
            }
            $lastfee = $estimatedFee;
            printf("%s  Estimated fee %10.8f%s\n", etime($t), $estimatedFee, $feediff);
        }

        if ($fee_file ne "") {
            open(FO, ">>$fee_file");
            print(FO "1,$t," . etime($t) . ",$estimatedFee\n");
        }

        my $block_end = sendRPCcommand([ "getblockcount" ]);
        if ($block_start < 0) {
            $block_start = $block_end;
        }

        for (my $j = $block_start; $j <= $block_end; $j++) {
            my $bsj = sendRPCcommand([ "getblockstats", $j ]);
            my $bs = decode_json($bsj);
            print(Data::Dumper->Dump([$bs], [ qw(getblockstats) ])) if $verbose >= 2;
            my $btime = $bs->{time};
            my ($feerate_min, $feerate_mean, $feerate_max) =
                ($bs->{minfeerate}, $bs->{avgfeerate}, $bs->{maxfeerate});
            my @feerate_percentiles = @{$bs->{feerate_percentiles}};

            if (!$quiet) {
                printf("  Block %d  %s\n    Fee rate min %d, mean %d, max %d\n",
                    $j, etime($btime),
                    $feerate_min, $feerate_mean, $feerate_max);
                printf("    Fee percentiles: " .
                    "10%% $feerate_percentiles[0]  25%% $feerate_percentiles[1]  " .
                    "50%% $feerate_percentiles[2]  75%% $feerate_percentiles[3]  " .
                    "90%% $feerate_percentiles[4]\n");
            }
            if ($fee_file ne "") {
                print(FO "2,$btime," . etime($btime) . ",$j," .
                    "$feerate_min,$feerate_mean,$feerate_max," .
                    "$feerate_percentiles[0],$feerate_percentiles[1]," .
                    "$feerate_percentiles[2],$feerate_percentiles[3]," .
                    "$feerate_percentiles[4]\n");
            }
        }
        if ($fee_file ne "") {
            close(FO);
        }
        $block_start = $block_end + 1;
    }

    
        sub showHelp {
            my $help = <<"    EOD";
    perl fee_watch.pl [ option... ]
      Commands and arguments:
        -confirmed n        Confirmations to deem transaction confirmed
        -ffile filename     Log file for fee statistics
        -help               Print this message
        -poll n             Poll for new block every n seconds, 0 = never
        -quiet              Suppress console output
        -type Any text      Display text argument on standard output
        -verbose            Print debug information, more for every -verbose
      
      Bitcoin API access configuration options:
        -clipath path       Path name to execute bitcoin-cli command line utility
        -host hostname      Host (name or IP address) where Bitcoin Core runs
        -method which       Query method: local, rpc, ssh
        -rpcpass "text"     Bitcoin RPC API password
        -port n             Port for RPC API requests (default 8332)
        -user userid        User name for requests via ssh
    EOD
            $help =~ s/^    //gm;
            print($help);
            exit(0);
        }
    

    
        sub etime {
            my ($t) = @_;

            return strftime("%F %T", gmtime($t));
        }
    
    
        sub processCommand {
            my ($command, $interactive) = @_;

            my ($verb, $noun) = ("", "");
            $command =~ s/\s+$//;
            #   Ignore blank lines and comments
            if (($command ne "") && ($command !~ m/^\s*#/)) {
                $command =~ m/^\s*(\w+)(?:\s+(\S.*?))?\s*$/ ||
                    die("Unable to parse command \"$command\"\n");
                ($verb, $noun) = ($1, $2);
                my $inop = TRUE;
                foreach my $op (keys(%options)) {
                    $op =~ s/(?:\+|=\w+)$//;
                    if ($op eq $verb) {
                        $inop = FALSE;
                        last;
                    }
                }
                if ($inop) {
                    if ($interactive) {
                        return ("", "") if ($verb =~ m/^(?:en|ex|qu)/);
                        print("Unknown command/option \"$verb\".\n");
                        return ("?", "");
                    } else {
                        return ("", "");
                    }
                }
                $noun = "" if (!defined($noun));
                my @optarr = ( "-$verb" );
                if ($noun ne "") {
                    push(@optarr, $noun);
                }
                if (!GetOptionsFromArray(\@optarr, %options)) {
                    if ($interactive) {
                        print("Error in command \"$command\".\n");
                    }
                }
            }
            return ($verb, $noun);
        }
    
        my $interactive = FALSE;

        sub arg_inter {
            $interactive = TRUE;
            while (TRUE) {
                print("> ");
                my $l = <> || last;
                chomp($l);
                if ($l !~ m/^\s*$/) {
                    my ($v, $n) = (" ", "");
                    eval {
                        ($v, $n) = processCommand($l, TRUE);
                    };
                    last if ($v eq "");
                }
            }
            $interactive = FALSE;
        }
    
        sub processCommandFile {
            my ($fname) = @_;

            open(CI, "<$fname") ||
                die("Cannot open command file $fname");

            while (my $l = <CI>) {
                chomp($l);
                my ($v, $n) = processCommand($l, FALSE);
            }
            close(CI);
        }
    
        sub processConfiguration {
            if (-f "blockchain_tools.conf") {
                processCommandFile("blockchain_tools.conf");
            }
            my $progName = "perl/fee_watch.pl";
            $progName =~ m|^(?:[^/]*/)?(\w+)\.\w+$| ||
                die("Cannot extract program name from $progName");
            $progName = $1;
            if (-f "$progName.conf") {
                processCommandFile("$progName.conf");
            }
        }
    
    
        sub sendRPCcommand {
            my ($args) = @_;

            my $result;

            if ($RPCmethod eq "local") {
                
                    map({ s/^(\[.*?\])$/'$1'/ } @$args);
                    my $cmd = join(" ", @$args);
                    $result = `$RPCcli $cmd 2>&1`;

                

            } elsif ($RPCmethod eq "ssh") {
                
                    map({ s/^(\[.*?\])$/'$1'/ } @$args);
                    my $cmd = join(" ", @$args);
                    $cmd =~ s/"/\\"/g;
                    $result = `ssh $RPChost $RPCcli \"$cmd\" 2>&1`;
                

             } elsif ($RPCmethod eq "rpc") {
                
                    my $method = shift(@$args);
                
                    for (my $i = 0; $i < scalar(@$args); $i++) {
                        if ($args->[$i] !~ m/^(?:true|false|null|[\d\.]+|".*"|\[.*?\])$/) {
                            my $s = $args->[$i];
                            $s =~ s/"/\\"/g;
                            $args->[$i] = "\"$s\"";
                        }
                    }
                
                    my $params = join(",\n        ", @$args);
                    my $request = LWP::UserAgent->new();
                    $request->agent("trans_watch");
                    #   Specify requester's credentials, including user and password
                    $request->credentials("$RPChost:$RPCport", "jsonrpc",
                        $RPCuser, $RPCpass);
                    #   Compose JSON query to be sent via POST
                    my $query = <<"                EOD";
                {
                "jsonrpc": "1.0",
                "id": "trans_watch",
                "method": "$method",
                "params": [
                $params
                ]
                }
                EOD
                
                    my $rq = HTTP::Request->new("POST",
                                                "http://$RPChost:$RPCport/",
                                                [ "Content-Type" => "text/plain" ],
                                                $query);
                    my $reply = $request->request($rq);
                
                    if ($reply->{_rc} == 200) {
                        $result = $reply->{_content};
                        $result =~ s/^\{"result":(.*?)(,"error":[^\{]+\})$/$1/ ||
                            die("Cannot extract RPC result");
                        my $errstat = $2;
                        if ($errstat !~ m/"error"\s*:\s*null/) {
                            $result = undef;
                        }
                    }
                

           } else {
                print(STDERR "Unknown -method configured: \"$RPCmethod\".\n");
                exit(1);
            }

            if (defined($result)) {
                chomp($result);
            }

            return $result;
        }
    
    
        sub getPassword {
            my ($prompt) = @_;

            ReadMode("noecho");
            print(STDERR $prompt);
            my $pw = <STDIN>;
            chomp($pw);
            ReadMode("original");
            return $pw;
        }
    
