#! /usr/bin/python3


    #   NOTE: This program was automatically generated by the Nuweb
    #   literate programming tool.  It is not intended to be modified
    #   directly.  If you wish to modify the code or use it in another
    #   project, you should start with the master, which is kept in the
    #   file blockchain_tools.w in the public GitHub repository:
    #       https://github.com/Fourmilab/blockchain_tools.git
    #   and is documented in the file blockchain_tools.pdf in the root directory
    #   of that repository.

    #
    #   Build 818  2021-10-24 21:02


import fileinput
import re
import sys

#   - - -  Bitcoin  - - -

import base58
import binascii
from cryptos import Bitcoin


def getPrivateKey(WIF):
    first_encode = base58.b58decode(WIF)
    private_key_full = binascii.hexlify(first_encode)
    private_key = private_key_full[2:-8]
    return private_key


def WIF_to_Bitcoin_address(WIF):
    c = Bitcoin(testnet=False)
    pk = getPrivateKey(WIF)
    BTCaddr = c.privtoaddr(pk)
    return BTCaddr


#   - - -  Ethereum  - - -

from coincurve import PublicKey
from sha3 import keccak_256


def checksumETHaddr(address):
    haddr = address.hex()
    formatted_address = ""
    addressHash = keccak_256(str(haddr).encode("UTF-8")).digest()[:40].hex()
    for i in range(40):
        if (int(addressHash[i], 16) >= 8 and int(haddr[i], 16) >= 10):
            formatted_address += str(haddr[i]).upper()
        else:
            formatted_address += str(haddr[i])
    return formatted_address


def Key_to_Ethereum_address(privkey_hex):
    private_key = bytes.fromhex(privkey_hex)
    public_key = PublicKey.from_valid_secret(private_key).format(compressed=False)[1:]
    public_addr_b = keccak_256(public_key).digest()[-20:]
    public_addr = checksumETHaddr(public_addr_b)
    return public_addr


#   - - -  Utility functions  - - -

sep = re.compile('<span class="s"></span>')

def removeSep(addr):
    return sep.sub("", addr, 0)


l = ""
lineno = 0
html = False
comment = re.compile(r'\s*#')
csv = re.compile(r'(\w+),"(\w+)","(\w+)"')
ifile = fileinput.input()
goodRec = 0
badRec = 0

def nextAddr():
    global l, lineno, html, badRec
    EXnum = EXpub = EXpriv = False
    Hstate = 0

    while True:
        l = ifile.readline()
        if not l:
            break
        lineno += 1
        l = l.rstrip()
        if l.find("<!DOCTYPE html>") >= 0:
            html = True
        else:

            if html:
                if l.find('th class="num"') >= 0:
                    if Hstate == 0:
                        EXnum = True
                    else:
                        print("%d: HTML format error: %s" % (lineno, l))
                        badRec += 1
                        Hstate = 0
                elif l.find('td class="pub"') >= 0:
                    if Hstate == 1:
                        EXpub = True
                    else:
                        print("%d: HTML format error: %s" % (lineno, l))
                        badRec += 1
                        Hstate = 0
                elif l.find('td class="priv"') >= 0:
                    if Hstate == 2:
                        EXpriv = True
                    else:
                        print("%d: HTML format error: %s" % (lineno, l))
                        badRec += 1
                        Hstate = 0
                else:
                    #   If one of the field flags has been set on the
                    #   previous line, save this one as the value of
                    #   that field.
                    if EXnum:
                        Hnum = l.lstrip().rstrip()
                        EXnum = False
                        Hstate = 1
                    elif EXpub:
                        Hpub = removeSep(l.lstrip().rstrip())
                        EXpub = False
                        Hstate = 2
                    elif EXpriv:
                        #   If this is the private key, we've now seen
                        #   all of the fields for this record.  Return
                        #   the fields to the caller.  We leave things
                        #   set to start scanning for the next record
                        #   when we're next called.
                        Hpriv = removeSep(l.lstrip().rstrip())
                        EXpriv = False
                        return (Hnum, Hpub, Hpriv, currencyID(Hpub, Hpriv))

            else:
                if not ((l == "") or comment.match(l)):
                    #   This is not a comment.  Try parsing as a CSV record
                    r = csv.match(l)
                    if r:
                        return (r.group(1), r.group(2), r.group(3),
                                currencyID(r.group(2), r.group(3)))
                    print("%d.  Cannot parse CSV record: %s" % (lineno, l))
                    badRec += 1
    return ("", "", "", "")


ETHpub = re.compile(r"0x([\da-fA-F]+)")
ETHpriv = re.compile(r"0x([\da-fA-F]+)")
BTCpub = re.compile(r"(1[1-9A-HJ-NP-Za-km-z]+)")
BTCpriv = re.compile(r"([KL][1-9A-HJ-NP-Za-km-z]+)")

def currencyID(pub, priv):
    curr = "?"
    if (ETHpub.match(pub)) and (ETHpriv.match(priv)):
        curr = "ETH"
    elif (BTCpub.match(pub)) and (BTCpriv.match(priv)):
        curr = "BTC"
    return curr



currency = ""

fileinput.input()
while True:
    (label, pubaddrW, privkey, rcurr) = nextAddr()
    if label == "": break
    if rcurr == "?":
        print("%d.  Record represents no known currency: %s" %
              (lineno, l))
        badRec += 1
    else:
        if (currency != "") and (currency != rcurr):
            print("%d.  Currency (%s) differs from that of previous record (%s)." %
                  (lineno, rcurr, currency))
        currency = rcurr

        pubaddr = ""
        if currency == "BTC":
            pubaddr = WIF_to_Bitcoin_address(privkey)
        elif currency == "ETH":
            pubaddr = "0x" + Key_to_Ethereum_address(privkey[2:])

    if pubaddrW != pubaddr:
        print("%d.  Mismatch on address %s.\n    Computed: %s\n    Wallet:   %s" %
              (lineno, label, pubaddr, pubaddrW))
        badRec += 1
    else:
        goodRec += 1


print("Addresses: %d good, %d bad." % (goodRec, badRec))
sys.exit(0 if ((goodRec > 0) and (badRec == 0)) else 1)
