#! /usr/bin/perl

#   RPM HOGS !

#   Look at all the RPMs installed on a Linux system and rank them in
#   descending order of disc space consumed.

#   	    by John Walker -- 2002-05-27
#   	      http://www.fourmilab.ch/


    #	Set $ThousandsSeparator to the character you wish to
    #	separate groups of three digits when printing numbers.
    #	Leave undefined if you prefer no thousands separator. 
    $ThousandsSeparator = ',';
    
    #	$SizeFieldSize is the number of columns to allot for
    #	the size field in the report.  If $ThousandsSeparator
    #	is defined, a setting of 13 handles all values less than
    #	10 Gb.
    $SizeFieldSize = 13;
    
    #	$FieldSeparator is the sequence of characters which appear
    #	between the size and the package name.  By default, this is
    #	two spaces, but you may wish to change it to a tab or comma
    #	if that makes parsing by a downstream program easier.
    $FieldSeparator = '  ';

    #	Create pipe to RPM command to obtain list of all packages

    open(IF, 'rpm --query --all |');

    #	Read the list of packages so-generated and use
    #	the companion program "rpmsize.pl" to compute the
    #	total size of files installed by the package, in
    #	bytes.
        
    $n = 0;
    while ($f = <IF>) {
    	chop($f);
	$s = `perl rpmsize.pl $f`;
	chop($s);
    	$hogs[$n++] = "$s $f";
    }
    close(IF);
    
    #	At this point @hogs contains a list of sizes and
    #	package names in whatever order RPM returned them.
    #	Sort them in descending order by total size, using
    #	the comparison subroutine "bysize".
    
    @hawgs = sort(bysize @hogs);
    
    #	Walk through the sorted array, printing lines
    #	nicely formatted with the designated
    #	$ThousandsSeparator, if defined.  The total is
    #	computed along the way and displayed at the end.
    
    $total = 0;
    for ($i = 0; $i < $n; $i++) {
    	$hawgs[$i] =~ m/(\d+)\s(.*.)$/;
	$size = $1;
	$total += $size;
	$package = $2;
    	$csize = &commas($size);
    	printf("%${SizeFieldSize}s${FieldSeparator}%s \n", $csize, $package);
    }
    
    printf("\n%${SizeFieldSize}s${FieldSeparator}Total\n", &commas($total));
    
    #	Comparison subroutine to sort records in descending
    #	order of size.
    
    sub bysize {
	$a =~ m/(\d+)/;
	$s1 = $1;
	$b =~ m/(\d+)/;
	$s2 = $1;
	return -($s1 <=> $s2);
    }
    
    #	Format a number argument by inserting the designated
    #	thousands separator between groups of three digits.
    #	If $ThousandsSeparator is not defined, the number is
    #	returned unchanged.
    
    sub commas {
    	local($num) = @_;
	local $csize = '';
	
	if (defined($ThousandsSeparator)) {
	    while ($num =~ m/\d(\d\d\d$)/) {
		$csize = "$csize$ThousandsSeparator$1";
		$num =~ s/\d\d\d$//;
	    }
	    $csize = "$num$csize";
	} else {
	    $csize = $num;
	}
    	return $csize;
    }
