#! /usr/bin/perl

#   Calculate total size used by all files in a given RPM package

#   	    by John Walker -- 2002-05-27
#   	      http://www.fourmilab.ch/

    #	Obtain package name from first command line argument.
    #	If no argument or more than one argument is supplied,
    #	print how to call information and quit.
    
    if ($#ARGV == 0) {
    	$pkg = $ARGV[0];
    } else {
    	print("usage: rpmsize.pl RPM_package_name\n");
	print("       Prints total size of all files in package.\n");
    	exit(1);
    }
    
    #	Open a pipe to an RPM command which returns a list
    #	of all files in the package with size and signature
    #	information.  We examine only the size.
    
    open(IF, "rpm --query -l --dump $pkg |");
    
    #	Loop through the files in the package, extracting
    #	and summing the sizes.
    
    $s = 0;
    while ($l = <IF>) {
	$l =~ m/\s*\s(\d+)\s/;
	$s += $1;
    }
    close(IF);
    
    #	That's it--print the total size on standard output
    
    print("$s\n");
